/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.commandline;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.router.operation.AddRedundancy;
import picocli.CommandLine;

@CommandLine.Command(description={"add redundancy"}, name="addRedundancy", aliases={"add"}, mixinStandardHelpOptions=true)
public class CommandLineHandlerRedundancyAdd
implements Callable<Integer> {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    @CommandLine.Option(names={"--infile", "-i"}, required=true, description={"filename of the file to add redundancy"})
    String inFile;
    @CommandLine.Option(names={"--outfile", "-o"}, required=true, description={"output filename"})
    String outFile;
    @CommandLine.Option(names={"--redundancyBlocks"}, required=true, description={"the number of blocks which may be removed"})
    int redundancyBlocks;
    @CommandLine.Option(names={"--blocks"}, required=true, description={"the number of blocks"})
    int numBlocks;
    @CommandLine.Option(names={"--gf"}, required=true, description={"the size of the gauloise field in bits"})
    int gf;

    @Override
    public Integer call() throws Exception {
        if (!new File(this.inFile).exists()) {
            LOGGER.log(Level.SEVERE, "File \"" + this.inFile + "\" not found");
            return 103;
        }
        LOGGER.log(Level.INFO, "Loading file \"" + this.inFile + "\"");
        byte[] buffer = new byte[(int)new File(this.inFile).length()];
        try (InputStream fis = Files.newInputStream(Paths.get(this.inFile, new String[0]), new OpenOption[0]);){
            fis.read(buffer);
        }
        LOGGER.log(Level.INFO, "adding redundancy");
        byte[] out = AddRedundancy.execute(buffer, this.redundancyBlocks, this.numBlocks, this.gf);
        LOGGER.log(Level.INFO, "writing output");
        try (OutputStream fos = Files.newOutputStream(Paths.get(this.outFile, new String[0]), new OpenOption[0]);){
            fos.write(out);
        }
        LOGGER.log(Level.INFO, "finished");
        return 0;
    }
}

