/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.holder;

import com.hazelcast.client.impl.protocol.task.dynamicconfig.EvictionConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.DataPersistenceConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.ExpiryPolicy;

public class CacheConfigHolder {
    private final String name;
    private final String managerPrefix;
    private final String uriString;
    private final int backupCount;
    private final int asyncBackupCount;
    private final String inMemoryFormat;
    private final EvictionConfigHolder evictionConfigHolder;
    private final WanReplicationRef wanReplicationRef;
    private final String keyClassName;
    private final String valueClassName;
    private final Data cacheLoaderFactory;
    private final Data cacheWriterFactory;
    private final Data expiryPolicyFactory;
    private final boolean isReadThrough;
    private final boolean isWriteThrough;
    private final boolean isStoreByValue;
    private final boolean isManagementEnabled;
    private final boolean isStatisticsEnabled;
    private final HotRestartConfig hotRestartConfig;
    private final boolean merkleTreeConfigExists;
    private final MerkleTreeConfig merkleTreeConfig;
    private final EventJournalConfig eventJournalConfig;
    private final String splitBrainProtectionName;
    private final List<Data> listenerConfigurations;
    private final MergePolicyConfig mergePolicyConfig;
    private final boolean disablePerEntryInvalidationEvents;
    private final List<ListenerConfigHolder> cachePartitionLostListenerConfigs;
    private final boolean isDataPersistenceConfigExists;
    private final DataPersistenceConfig dataPersistenceConfig;
    private final boolean isNamespaceExists;
    @Nullable
    private final String userCodeNamespace;

    public CacheConfigHolder(String name, String managerPrefix, String uriString, int backupCount, int asyncBackupCount, String inMemoryFormat, EvictionConfigHolder evictionConfigHolder, WanReplicationRef wanReplicationRef, String keyClassName, String valueClassName, Data cacheLoaderFactory, Data cacheWriterFactory, Data expiryPolicyFactory, boolean isReadThrough, boolean isWriteThrough, boolean isStoreByValue, boolean isManagementEnabled, boolean isStatisticsEnabled, HotRestartConfig hotRestartConfig, EventJournalConfig eventJournalConfig, String splitBrainProtectionName, List<Data> listenerConfigurations, MergePolicyConfig mergePolicyConfig, boolean disablePerEntryInvalidationEvents, List<ListenerConfigHolder> cachePartitionLostListenerConfigs, boolean merkleTreeConfigExists, MerkleTreeConfig merkleTreeConfig, boolean isDataPersistenceConfigExist, DataPersistenceConfig dataPersistenceConfig, boolean isNamespaceExists, String userCodeNamespace) {
        this.name = name;
        this.managerPrefix = managerPrefix;
        this.uriString = uriString;
        this.backupCount = backupCount;
        this.asyncBackupCount = asyncBackupCount;
        this.inMemoryFormat = inMemoryFormat;
        this.evictionConfigHolder = evictionConfigHolder;
        this.wanReplicationRef = wanReplicationRef;
        this.keyClassName = keyClassName;
        this.valueClassName = valueClassName;
        this.cacheLoaderFactory = cacheLoaderFactory;
        this.cacheWriterFactory = cacheWriterFactory;
        this.expiryPolicyFactory = expiryPolicyFactory;
        this.isReadThrough = isReadThrough;
        this.isWriteThrough = isWriteThrough;
        this.isStoreByValue = isStoreByValue;
        this.isManagementEnabled = isManagementEnabled;
        this.isStatisticsEnabled = isStatisticsEnabled;
        this.hotRestartConfig = hotRestartConfig;
        this.eventJournalConfig = eventJournalConfig;
        this.splitBrainProtectionName = splitBrainProtectionName;
        this.listenerConfigurations = listenerConfigurations;
        this.mergePolicyConfig = mergePolicyConfig;
        this.disablePerEntryInvalidationEvents = disablePerEntryInvalidationEvents;
        this.cachePartitionLostListenerConfigs = cachePartitionLostListenerConfigs;
        this.merkleTreeConfigExists = merkleTreeConfigExists;
        this.merkleTreeConfig = merkleTreeConfig;
        this.isDataPersistenceConfigExists = isDataPersistenceConfigExist;
        this.dataPersistenceConfig = dataPersistenceConfig;
        this.isNamespaceExists = isNamespaceExists;
        this.userCodeNamespace = userCodeNamespace;
    }

    public String getName() {
        return this.name;
    }

    public String getManagerPrefix() {
        return this.managerPrefix;
    }

    public String getUriString() {
        return this.uriString;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public String getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public EvictionConfigHolder getEvictionConfigHolder() {
        return this.evictionConfigHolder;
    }

    public WanReplicationRef getWanReplicationRef() {
        return this.wanReplicationRef;
    }

    public String getKeyClassName() {
        return this.keyClassName;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    public Data getCacheLoaderFactory() {
        return this.cacheLoaderFactory;
    }

    public Data getCacheWriterFactory() {
        return this.cacheWriterFactory;
    }

    public Data getExpiryPolicyFactory() {
        return this.expiryPolicyFactory;
    }

    public boolean isReadThrough() {
        return this.isReadThrough;
    }

    public boolean isWriteThrough() {
        return this.isWriteThrough;
    }

    public boolean isStoreByValue() {
        return this.isStoreByValue;
    }

    public boolean isManagementEnabled() {
        return this.isManagementEnabled;
    }

    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    public HotRestartConfig getHotRestartConfig() {
        return this.hotRestartConfig;
    }

    public DataPersistenceConfig getDataPersistenceConfig() {
        return this.dataPersistenceConfig;
    }

    public EventJournalConfig getEventJournalConfig() {
        return this.eventJournalConfig;
    }

    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    public List<Data> getListenerConfigurations() {
        return this.listenerConfigurations;
    }

    public MergePolicyConfig getMergePolicyConfig() {
        return this.mergePolicyConfig;
    }

    public boolean isDisablePerEntryInvalidationEvents() {
        return this.disablePerEntryInvalidationEvents;
    }

    public List<ListenerConfigHolder> getCachePartitionLostListenerConfigs() {
        return this.cachePartitionLostListenerConfigs;
    }

    public MerkleTreeConfig getMerkleTreeConfig() {
        return this.merkleTreeConfig;
    }

    public boolean isMerkleTreeConfigExists() {
        return this.merkleTreeConfigExists;
    }

    public String getUserCodeNamespace() {
        return this.userCodeNamespace;
    }

    public <K, V> CacheConfig<K, V> asCacheConfig(SerializationService serializationService) {
        CacheConfig config = new CacheConfig();
        config.setName(this.name);
        config.setManagerPrefix(this.managerPrefix);
        config.setUriString(this.uriString);
        config.setBackupCount(this.backupCount);
        config.setAsyncBackupCount(this.asyncBackupCount);
        config.setInMemoryFormat(InMemoryFormat.valueOf(this.inMemoryFormat));
        config.setEvictionConfig(this.evictionConfigHolder.asEvictionConfig(serializationService));
        config.setWanReplicationRef(this.wanReplicationRef);
        config.setKeyClassName(this.keyClassName);
        config.setValueClassName(this.valueClassName);
        config.setCacheLoaderFactory((Factory)serializationService.toObject(this.cacheLoaderFactory));
        config.setCacheWriterFactory((Factory)serializationService.toObject(this.cacheWriterFactory));
        config.setExpiryPolicyFactory((Factory<ExpiryPolicy>)((Factory)serializationService.toObject(this.expiryPolicyFactory)));
        config.setReadThrough(this.isReadThrough);
        config.setWriteThrough(this.isWriteThrough);
        config.setStoreByValue(this.isStoreByValue);
        config.setManagementEnabled(this.isManagementEnabled);
        config.setStatisticsEnabled(this.isStatisticsEnabled);
        config.setHotRestartConfig(this.hotRestartConfig);
        config.setEventJournalConfig(this.eventJournalConfig);
        config.setSplitBrainProtectionName(this.splitBrainProtectionName);
        if (this.listenerConfigurations != null && !this.listenerConfigurations.isEmpty()) {
            config.setListenerConfigurations();
            this.listenerConfigurations.forEach(listener -> config.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)serializationService.toObject(listener)));
        }
        config.setMergePolicyConfig(this.mergePolicyConfig);
        config.setDisablePerEntryInvalidationEvents(this.disablePerEntryInvalidationEvents);
        if (this.merkleTreeConfigExists) {
            config.setMerkleTreeConfig(this.merkleTreeConfig);
        }
        if (this.cachePartitionLostListenerConfigs != null) {
            ArrayList<CachePartitionLostListenerConfig> partitionLostListenerConfigs = new ArrayList<CachePartitionLostListenerConfig>(this.cachePartitionLostListenerConfigs.size());
            this.cachePartitionLostListenerConfigs.forEach(listenerConfigHolder -> partitionLostListenerConfigs.add((CachePartitionLostListenerConfig)listenerConfigHolder.asListenerConfig(serializationService, this.userCodeNamespace)));
            config.setPartitionLostListenerConfigs(partitionLostListenerConfigs);
        }
        if (this.isDataPersistenceConfigExists) {
            config.setDataPersistenceConfig(this.dataPersistenceConfig);
        }
        if (this.isNamespaceExists) {
            config.setUserCodeNamespace(this.userCodeNamespace);
        }
        return config;
    }

    public static <K, V> CacheConfigHolder of(CacheConfig<K, V> config, SerializationService serializationService) {
        if (config == null) {
            return null;
        }
        ArrayList<Data> listenerConfigurations = null;
        Set entryListenerConfigurations = config.getListenerConfigurations();
        if (entryListenerConfigurations != null && !entryListenerConfigurations.isEmpty()) {
            ArrayList<Data> configDatas = listenerConfigurations = new ArrayList<Data>(entryListenerConfigurations.size());
            entryListenerConfigurations.forEach(listenerConfig -> configDatas.add((Data)serializationService.toData(listenerConfig)));
        }
        ArrayList<ListenerConfigHolder> cachePartitionLostListenerConfigs = null;
        List<CachePartitionLostListenerConfig> partitionLostListenerConfigs = config.getPartitionLostListenerConfigs();
        if (partitionLostListenerConfigs != null) {
            ArrayList<ListenerConfigHolder> configs = cachePartitionLostListenerConfigs = new ArrayList<ListenerConfigHolder>(partitionLostListenerConfigs.size());
            partitionLostListenerConfigs.forEach(listenerConfig -> configs.add(ListenerConfigHolder.of(listenerConfig, serializationService, config.getUserCodeNamespace())));
        }
        return new CacheConfigHolder(config.getName(), config.getManagerPrefix(), config.getUriString(), config.getBackupCount(), config.getAsyncBackupCount(), config.getInMemoryFormat().name(), EvictionConfigHolder.of(config.getEvictionConfig(), serializationService), config.getWanReplicationRef(), config.getKeyClassName(), config.getValueClassName(), (Data)serializationService.toData(config.getCacheLoaderFactory()), (Data)serializationService.toData(config.getCacheWriterFactory()), (Data)serializationService.toData(config.getExpiryPolicyFactory()), config.isReadThrough(), config.isWriteThrough(), config.isStoreByValue(), config.isManagementEnabled(), config.isStatisticsEnabled(), config.getHotRestartConfig(), config.getEventJournalConfig(), config.getSplitBrainProtectionName(), (List<Data>)listenerConfigurations, config.getMergePolicyConfig(), config.isDisablePerEntryInvalidationEvents(), (List<ListenerConfigHolder>)cachePartitionLostListenerConfigs, config.getMerkleTreeConfig() != null, config.getMerkleTreeConfig(), true, config.getDataPersistenceConfig(), config.getUserCodeNamespace() != null, config.getUserCodeNamespace());
    }
}

