/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.dynamicconfig;

import com.hazelcast.internal.namespace.ResourceDefinition;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

public class ResourceDefinitionHolder {
    private final String id;
    private final int resourceType;
    @Nullable
    private final byte[] payload;
    @Nullable
    private final String resourceUrl;

    public ResourceDefinitionHolder(ResourceDefinition resourceDefinition) {
        this.id = resourceDefinition.id();
        this.resourceType = resourceDefinition.type().ordinal();
        this.payload = resourceDefinition.payload();
        this.resourceUrl = this.payload == null ? resourceDefinition.url() : null;
    }

    public ResourceDefinitionHolder(String id, int resourceType, @Nullable byte[] payload, @Nullable String resourceUrl) {
        this.id = id;
        this.resourceType = resourceType;
        this.payload = payload;
        this.resourceUrl = resourceUrl;
    }

    public String getId() {
        return this.id;
    }

    public int getResourceType() {
        return this.resourceType;
    }

    @Nullable
    public byte[] getPayload() {
        return this.payload;
    }

    @Nullable
    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.payload);
        result = 31 * result + Objects.hash(this.id, this.resourceType, this.resourceUrl);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceDefinitionHolder other = (ResourceDefinitionHolder)obj;
        return Objects.equals(this.id, other.id) && Arrays.equals(this.payload, other.payload) && this.resourceType == other.resourceType && Objects.equals(this.resourceUrl, other.resourceUrl);
    }
}

