/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.tpc;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.annotation.Beta;
import java.util.Objects;
import javax.annotation.Nonnull;

@Beta
public class TpcConfig {
    private boolean enabled;
    private int eventloopCount = Runtime.getRuntime().availableProcessors();

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nonnull
    public TpcConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public int getEventloopCount() {
        return this.eventloopCount;
    }

    @Nonnull
    public TpcConfig setEventloopCount(int eventloopCount) {
        this.eventloopCount = Preconditions.checkPositive("eventloopCount", eventloopCount);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TpcConfig that = (TpcConfig)o;
        return this.enabled == that.enabled && this.eventloopCount == that.eventloopCount;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.eventloopCount);
    }

    public String toString() {
        return "TpcConfig{enabled=" + this.enabled + ", eventloopCount=" + this.eventloopCount + "}";
    }
}

