/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.serialization.impl.portable.DeserializedPortableGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.nio.serialization.genericrecord.GenericRecordBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PortableGenericRecordBuilder
implements GenericRecordBuilder {
    private final ClassDefinition classDefinition;
    private final Object[] objects;
    private final boolean[] isSet;
    private final boolean isClone;

    public PortableGenericRecordBuilder(ClassDefinition classDefinition) {
        this.classDefinition = classDefinition;
        this.objects = new Object[classDefinition.getFieldCount()];
        this.isClone = false;
        this.isSet = new boolean[this.objects.length];
    }

    PortableGenericRecordBuilder(ClassDefinition classDefinition, Object[] objects) {
        this.classDefinition = classDefinition;
        this.objects = objects;
        this.isClone = true;
        this.isSet = new boolean[objects.length];
    }

    @Override
    @Nonnull
    public GenericRecord build() {
        if (!this.isClone) {
            for (int i2 = 0; i2 < this.isSet.length; ++i2) {
                if (this.isSet[i2]) continue;
                throw new HazelcastSerializationException("All fields must be written when building a GenericRecord for portable, unwritten field :" + this.classDefinition.getField(i2));
            }
        }
        return new DeserializedPortableGenericRecord(this.classDefinition, this.objects);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt32(@Nonnull String fieldName, int value) {
        return this.set(fieldName, value, FieldType.INT);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt64(@Nonnull String fieldName, long value) {
        return this.set(fieldName, value, FieldType.LONG);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setString(@Nonnull String fieldName, String value) {
        return this.set(fieldName, value, FieldType.UTF);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setBoolean(@Nonnull String fieldName, boolean value) {
        return this.set(fieldName, value, FieldType.BOOLEAN);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt8(@Nonnull String fieldName, byte value) {
        return this.set(fieldName, value, FieldType.BYTE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setChar(@Nonnull String fieldName, char value) {
        return this.set(fieldName, Character.valueOf(value), FieldType.CHAR);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloat64(@Nonnull String fieldName, double value) {
        return this.set(fieldName, value, FieldType.DOUBLE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloat32(@Nonnull String fieldName, float value) {
        return this.set(fieldName, Float.valueOf(value), FieldType.FLOAT);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt16(@Nonnull String fieldName, short value) {
        return this.set(fieldName, value, FieldType.SHORT);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableBoolean(@Nonnull String fieldName, @Nullable Boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt8(@Nonnull String fieldName, @Nullable Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableFloat64(@Nonnull String fieldName, @Nullable Double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableFloat32(@Nonnull String fieldName, @Nullable Float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt32(@Nonnull String fieldName, @Nullable Integer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt64(@Nonnull String fieldName, @Nullable Long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt16(@Nonnull String fieldName, @Nullable Short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setGenericRecord(@Nonnull String fieldName, @Nullable GenericRecord value) {
        PortableGenericRecordBuilder.checkPortableGenericRecord(value);
        return this.set(fieldName, value, FieldType.PORTABLE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDecimal(@Nonnull String fieldName, @Nullable BigDecimal value) {
        return this.set(fieldName, value, FieldType.DECIMAL);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTime(@Nonnull String fieldName, @Nullable LocalTime value) {
        return this.set(fieldName, value, FieldType.TIME);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDate(@Nonnull String fieldName, @Nullable LocalDate value) {
        return this.set(fieldName, value, FieldType.DATE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime value) {
        return this.set(fieldName, value, FieldType.TIMESTAMP);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime value) {
        return this.set(fieldName, value, FieldType.TIMESTAMP_WITH_TIMEZONE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfGenericRecord(@Nonnull String fieldName, @Nullable GenericRecord[] value) {
        if (value != null) {
            for (GenericRecord genericRecord : value) {
                PortableGenericRecordBuilder.checkPortableGenericRecord(genericRecord);
            }
        }
        return this.set(fieldName, value, FieldType.PORTABLE_ARRAY);
    }

    private static void checkPortableGenericRecord(GenericRecord genericRecord) {
        if (genericRecord != null && !(genericRecord instanceof PortableGenericRecord)) {
            throw new HazelcastSerializationException("You can only use Portable GenericRecords in a Portable GenericRecordBuilder");
        }
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt8(@Nonnull String fieldName, @Nullable byte[] value) {
        return this.set(fieldName, value, FieldType.BYTE_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfBoolean(@Nonnull String fieldName, @Nullable boolean[] value) {
        return this.set(fieldName, value, FieldType.BOOLEAN_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfChar(@Nonnull String fieldName, @Nullable char[] value) {
        return this.set(fieldName, value, FieldType.CHAR_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt32(@Nonnull String fieldName, @Nullable int[] value) {
        return this.set(fieldName, value, FieldType.INT_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt64(@Nonnull String fieldName, @Nullable long[] value) {
        return this.set(fieldName, value, FieldType.LONG_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfFloat64(@Nonnull String fieldName, @Nullable double[] value) {
        return this.set(fieldName, value, FieldType.DOUBLE_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfFloat32(@Nonnull String fieldName, @Nullable float[] value) {
        return this.set(fieldName, value, FieldType.FLOAT_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt16(@Nonnull String fieldName, @Nullable short[] value) {
        return this.set(fieldName, value, FieldType.SHORT_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableBoolean(@Nonnull String fieldName, @Nullable Boolean[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt8(@Nonnull String fieldName, @Nullable Byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableFloat32(@Nonnull String fieldName, @Nullable Float[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt32(@Nonnull String fieldName, @Nullable Integer[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableFloat64(@Nonnull String fieldName, @Nullable Double[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt64(@Nonnull String fieldName, @Nullable Long[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt16(@Nonnull String fieldName, @Nullable Short[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfString(@Nonnull String fieldName, @Nullable String[] value) {
        return this.set(fieldName, value, FieldType.UTF_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfDecimal(@Nonnull String fieldName, @Nullable BigDecimal[] value) {
        return this.set(fieldName, value, FieldType.DECIMAL_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfTime(@Nonnull String fieldName, @Nullable LocalTime[] value) {
        return this.set(fieldName, value, FieldType.TIME_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfDate(@Nonnull String fieldName, @Nullable LocalDate[] value) {
        return this.set(fieldName, value, FieldType.DATE_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime[] value) {
        return this.set(fieldName, value, FieldType.TIMESTAMP_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime[] value) {
        return this.set(fieldName, value, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY);
    }

    private GenericRecordBuilder set(@Nonnull String fieldName, Object value, FieldType fieldType) {
        FieldDefinition fd = this.check(fieldName, fieldType);
        int index = fd.getIndex();
        if (this.isSet[index]) {
            if (!this.isClone) {
                throw new HazelcastSerializationException("It is illegal to the overwrite the field");
            }
            throw new HazelcastSerializationException("Field can only overwritten once with `newBuilderWithClone`");
        }
        this.objects[index] = value;
        this.isSet[index] = true;
        return this;
    }

    @Nonnull
    private FieldDefinition check(@Nonnull String fieldName, FieldType fieldType) {
        FieldDefinition fd = this.classDefinition.getField(fieldName);
        if (fd == null) {
            throw new HazelcastSerializationException("Invalid field name: '" + fieldName + "' for ClassDefinition {id: " + this.classDefinition.getClassId() + ", version: " + this.classDefinition.getVersion() + "}");
        }
        if (!fd.getType().equals((Object)fieldType)) {
            throw new HazelcastSerializationException("Invalid field type: '" + fieldName + "' for ClassDefinition {id: " + this.classDefinition.getClassId() + ", version: " + this.classDefinition.getVersion() + "}, expected : " + fd.getType() + ", given : " + fieldType);
        }
        return fd;
    }
}

