/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.foedus.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MsgRangeFilter {
    static final Pattern TWO_PART = Pattern.compile("(\\d+|\\*):(\\d+|\\*)");
    int top;
    int bottom;
    boolean isUid;

    public MsgRangeFilter(String rng, boolean uid) {
        if (rng.indexOf(58) == -1) {
            int value;
            this.top = value = Integer.parseInt(rng);
            this.bottom = value;
        } else {
            Matcher mat = TWO_PART.matcher(rng);
            if (mat.matches() && mat.groupCount() == 2) {
                String botGroup = mat.group(1);
                String topGroup = mat.group(2);
                this.bottom = "*".equals(botGroup) ? 0 : Integer.parseInt(botGroup);
                this.top = "*".equals(topGroup) ? Integer.MAX_VALUE : Integer.parseInt(topGroup);
            } else {
                throw new IllegalStateException("Can not create range filter from " + rng + ", uid=" + uid);
            }
        }
        this.isUid = uid;
    }

    public boolean includes(int seq) {
        return seq >= this.bottom && seq <= this.top;
    }
}

