/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.Serializable;
import net.messagevortex.asn1.Operation;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class MapBlockOperation
extends Operation
implements Serializable {
    public static final long serialVersionUID = 100000000002L;
    int originalId = -1;
    int newId = -1;

    MapBlockOperation() {
    }

    public MapBlockOperation(ASN1Encodable object) {
        this.parse(object);
    }

    @Override
    protected final void parse(ASN1Encodable to) {
        ASN1Sequence s1 = ASN1Sequence.getInstance(to);
        int i2 = 0;
        this.originalId = ASN1Integer.getInstance(s1.getObjectAt(i2++)).getValue().intValue();
        this.newId = ASN1Integer.getInstance(s1.getObjectAt(i2++)).getValue().intValue();
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumptype) {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("\r\n");
        sb.append(prefix).append("  originalId ").append(this.originalId).append(',').append("\r\n");
        sb.append(prefix).append("  newId ").append(this.newId).append("\r\n");
        sb.append(prefix).append('}').append("\r\n");
        return sb.toString();
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.originalId));
        v.add(new ASN1Integer(this.newId));
        return new DERSequence(v);
    }

    @Override
    public Operation getNewInstance(ASN1Encodable object) {
        return new MapBlockOperation(object);
    }
}

