/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.blender.generators;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.ExtendedSecureRandom;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.BlendingParameter;
import net.messagevortex.asn1.VortexMessage;
import net.messagevortex.blender.BlenderContent;
import net.messagevortex.blender.generators.BlenderGenerator;

public class GenericGenerator
implements BlenderGenerator {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());

    @Override
    public BlenderContent getBlenderContent(BlendingParameter parameter, VortexMessage msg) throws IOException {
        BlenderContent cont = new BlenderContent();
        cont.setText("Hi\n\nHave you seen that one? Nice image!\n\nLove\nTeddy");
        File f = new File("images/F5Blender");
        cont.addAttachment(GenericGenerator.getFileContent(GenericGenerator.getRandomFile(f)));
        return cont;
    }

    private static File getRandomFile(File dir) throws IOException {
        File[] fa = dir.listFiles();
        if (fa == null || fa.length == 0) {
            throw new IOException("Directory \"" + String.valueOf(dir) + "\" is empty... there is no file to choose from");
        }
        return fa[ExtendedSecureRandom.nextInt(fa.length)];
    }

    private static byte[] getFileContent(File f) {
        byte[] b = null;
        try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);){
            b = new byte[(int)f.length()];
            is.read(b);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "unable to create file \"" + f.getAbsolutePath() + "\"", ioe);
        }
        return b;
    }
}

