/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.imap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.ClientConnection;
import net.messagevortex.transport.Credentials;
import net.messagevortex.transport.SaslClientCallbackHandler;
import net.messagevortex.transport.SaslMechanisms;
import net.messagevortex.transport.SecurityContext;
import net.messagevortex.transport.imap.ImapException;
import net.messagevortex.transport.imap.ImapLine;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class ImapClient
extends ClientConnection {
    private static final String REGEXP_IMAP_OK = "\\s+OK.*";
    private static final String REGEXP_IMAP_BAD = "\\s+BAD.*";
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private final Object sync = new Object();
    private final Object notifyThread = new Object();
    private String currentCommand = null;
    private String[] currentCommandReply = null;
    private boolean currentCommandCompleted = false;

    public ImapClient(InetSocketAddress addr, SecurityContext secContext) throws IOException {
        super(addr, secContext);
        this.setProtocol("IMAP");
    }

    public void imapStartTls() throws IOException {
        String tag = ImapLine.getNextTag();
        try {
            String[] ret = this.sendCommand(tag + " STARTTLS");
            if (ret != null && ret.length >= 1 && ret[ret.length - 1] != null && ret[ret.length - 1].startsWith(tag + " OK")) {
                this.startTls();
            }
        }
        catch (TimeoutException te) {
            throw new IOException("Timeout while communicating with server", te);
        }
    }

    public boolean authenticate(Credentials creds) throws TimeoutException {
        return this.authenticate(creds, SaslMechanisms.DIGEST_MD5);
    }

    public boolean authenticate(Credentials creds, SaslMechanisms mech) throws TimeoutException {
        SaslClientCallbackHandler clientHandler = new SaslClientCallbackHandler(creds);
        HashMap<String, String> props = new HashMap<String, String>();
        if (!this.isTls()) {
            props.put("javax.security.sasl.policy.noplaintext", "true");
        }
        try {
            String tag = ImapLine.getNextTag();
            this.writeln(tag + " AUTHENTICATE " + String.valueOf((Object)mech));
            SaslClient sc = Sasl.createSaslClient(new String[]{mech.toString()}, "username", "IMAP", creds.getRealm() != null ? creds.getRealm() : "localhost", props, clientHandler);
            if (sc == null) {
                LOGGER.log(Level.WARNING, "requested unsupported sasl mech (" + String.valueOf((Object)mech) + ")");
                return false;
            }
            String saslchallenge = this.readln();
            if (saslchallenge == null || !saslchallenge.startsWith("+ ")) {
                LOGGER.log(Level.WARNING, "Got a bad challenge from server (" + saslchallenge + ")");
                return false;
            }
            if (saslchallenge.equals("+ ")) {
                LOGGER.log(Level.INFO, "Got a empty challenge from server");
            } else {
                LOGGER.log(Level.INFO, "Got a challenge from server (" + saslchallenge + ")");
            }
            byte[] c = new byte[]{};
            if (saslchallenge.length() > 2) {
                LOGGER.log(Level.INFO, "Got a challenge from server (" + saslchallenge.length() + " bytes)");
                c = Base64.decode(saslchallenge.substring(2));
            }
            byte[] saslReply = sc.evaluateChallenge(c);
            String reply = new String(Base64.encode(saslReply), StandardCharsets.UTF_8);
            LOGGER.log(Level.INFO, "sending reply to server (" + saslReply.length + " bytes;" + reply + ")");
            this.writeln(reply);
            String imapReply = this.readln();
            return imapReply != null && imapReply.toLowerCase().startsWith(tag.toLowerCase() + " ok");
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "exception while authenticating", ioe);
            return false;
        }
    }

    public String[] sendCommand(String command) throws TimeoutException {
        return this.sendCommand(command, this.getTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] sendCommand(String command, long millisTimeout) throws TimeoutException {
        Object object = this.sync;
        synchronized (object) {
            this.currentCommand = command;
            LOGGER.log(Level.INFO, "sending \"" + ImapLine.commandEncoder(this.currentCommand) + "\" to server");
            long start = System.currentTimeMillis();
            this.currentCommandCompleted = false;
            this.currentCommandReply = new String[0];
            Object object2 = this.notifyThread;
            synchronized (object2) {
                this.notifyThread.notifyAll();
            }
            try {
                while (!this.currentCommandCompleted && System.currentTimeMillis() < start + millisTimeout) {
                    this.processLine(command, millisTimeout - (System.currentTimeMillis() - start));
                    try {
                        this.sync.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "got IO exception while processing command", ioe);
            }
            LOGGER.log(Level.FINEST, "wakeup succeeded");
            if (!this.currentCommandCompleted && System.currentTimeMillis() > start + millisTimeout) {
                throw new TimeoutException("Timeout reached while sending \"" + ImapLine.commandEncoder(command) + "\"");
            }
        }
        this.currentCommand = null;
        if (this.currentCommandReply == null || this.currentCommandReply.length == 0) {
            this.currentCommandReply = new String[0];
        } else {
            LOGGER.log(Level.INFO, "got \"" + ImapLine.commandEncoder(this.currentCommandReply[this.currentCommandReply.length - 1]) + "\" as reply from server (" + this.currentCommandReply.length + ")");
        }
        return (String[])this.currentCommandReply.clone();
    }

    private void interruptedCatcher(InterruptedException ie) {
        assert (false) : "This Point should never be reached (" + String.valueOf(ie) + ")";
        Thread.currentThread().interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForWakeupRunner() {
        Object object = this.notifyThread;
        synchronized (object) {
            try {
                this.notifyThread.wait(100L);
            }
            catch (InterruptedException e) {
                this.interruptedCatcher(e);
            }
        }
    }

    public void processLine(String line) throws IOException, TimeoutException {
        this.processLine(line, this.getTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLine(String line, long timeout) throws IOException, TimeoutException {
        this.currentCommand = line;
        LOGGER.log(Level.INFO, "IMAP C->S: " + ImapLine.commandEncoder(this.currentCommand));
        long start = System.currentTimeMillis();
        this.writeln(this.currentCommand, timeout);
        String tag = null;
        ImapLine il = null;
        try {
            il = new ImapLine(null, this.currentCommand);
            tag = il.getTag();
        }
        catch (ImapException ie) {
            LOGGER.log(Level.INFO, "ImapParsing of \"" + ImapLine.commandEncoder(this.currentCommand) + "\" (may be safelly ignored)", ie);
        }
        String lastReply = "";
        ArrayList<String> l = new ArrayList<String>();
        LOGGER.log(Level.INFO, "waiting for incoming reply of command " + tag + " (" + l.size() + ")");
        while (!lastReply.matches(tag + "\\s+BAD.*|" + tag + REGEXP_IMAP_OK) && System.currentTimeMillis() - start < timeout) {
            String reply = this.readln(timeout - (System.currentTimeMillis() - start));
            if (reply == null) continue;
            l.add(reply);
            lastReply = reply;
            LOGGER.log(Level.INFO, "IMAP C<-S: " + ImapLine.commandEncoder(reply) + " (" + l.size() + ")");
            this.currentCommandReply = l.toArray(new String[l.size()]);
        }
        this.currentCommandCompleted = lastReply.matches(tag + "\\s+OK.*|" + tag + REGEXP_IMAP_BAD);
        this.currentCommand = null;
        if (il != null && "logout".equalsIgnoreCase(il.getCommand()) && lastReply.matches(tag + REGEXP_IMAP_OK)) {
            this.shutdown();
        }
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
        LOGGER.log(Level.FINEST, "command has been completely processed");
    }

    private void runStep() throws IOException, TimeoutException {
        LOGGER.log(Level.INFO, "Waiting for command to process");
        this.startTls();
        this.waitForWakeupRunner();
        if (this.currentCommand != null && !"".equals(this.currentCommand)) {
            LOGGER.log(Level.INFO, "Processing command");
            this.processLine(this.currentCommand);
        }
        LOGGER.log(Level.FINEST, "Client looping (shutdown=" + this.isShutdown() + ")");
    }

    public void run() {
        try {
            while (!this.isShutdown()) {
                this.runStep();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Uncaught exception in ImapClient", e);
            try {
                this.shutdown();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Uncaught exception while shutting down", ioe);
            }
        }
        finally {
            try {
                this.shutdown();
            }
            catch (Exception e2) {
                LOGGER.log(Level.INFO, "socket close did fail when shutting down (may be safely ignored)", e2);
            }
        }
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

