/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.smtp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.ListeningSocketChannel;
import net.messagevortex.transport.SecurityContext;
import net.messagevortex.transport.ServerConnection;
import net.messagevortex.transport.SocketListener;
import net.messagevortex.transport.TransportReceiver;
import net.messagevortex.transport.smtp.SmtpConnection;

public class SmtpReceiver
implements SocketListener {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static volatile int gid = 1;
    private volatile int id = 1;
    private final ListeningSocketChannel listener;
    private TransportReceiver receiver = null;
    private SecurityContext context = null;

    public SmtpReceiver(InetSocketAddress address, SecurityContext secContext, TransportReceiver lreceiver) throws IOException {
        this.setTransportReceiver(lreceiver);
        this.listener = new ListeningSocketChannel(address, this);
        this.listener.setName("SMTPlist" + gid++);
        this.context = secContext;
    }

    @Override
    public void gotConnect(ServerConnection ac) {
        LOGGER.log(Level.INFO, "called gotConnection()");
        try {
            SmtpConnection s = new SmtpConnection(ac.getSocketChannel(), this.context, null);
            s.setName(this.listener.getName() + "-" + this.id++);
            s.setReceiver(this.receiver);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Exception while creating SmtpConnection object", ioe);
        }
    }

    public TransportReceiver getTransportReceiver() {
        return this.receiver;
    }

    public final TransportReceiver setTransportReceiver(TransportReceiver lreceiver) {
        TransportReceiver ret = this.receiver;
        this.receiver = lreceiver;
        return ret;
    }

    public void shutdown() {
        this.listener.shutdown();
    }

    public int getPort() {
        return this.listener.getPort();
    }
}

