/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;
import org.apache.commons.lang3.ArrayFill;

public class LocalVariables
implements Cloneable {
    private final Type[] locals;

    public LocalVariables(int localVariableCount) {
        this.locals = (Type[])ArrayFill.fill((Object[])new Type[localVariableCount], (Object)Type.UNKNOWN);
    }

    public Object clone() {
        LocalVariables lvs = new LocalVariables(this.locals.length);
        System.arraycopy(this.locals, 0, lvs.locals, 0, this.locals.length);
        return lvs;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalVariables)) {
            return false;
        }
        LocalVariables lv = (LocalVariables)o;
        if (this.locals.length != lv.locals.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            if (this.locals[i2].equals(lv.locals[i2])) continue;
            return false;
        }
        return true;
    }

    public Type get(int slotIndex) {
        return this.locals[slotIndex];
    }

    public LocalVariables getClone() {
        return (LocalVariables)this.clone();
    }

    public int hashCode() {
        return this.locals.length;
    }

    public void initializeObject(UninitializedObjectType uninitializedObjectType) {
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            if (this.locals[i2] != uninitializedObjectType) continue;
            this.locals[i2] = uninitializedObjectType.getInitialized();
        }
    }

    public int maxLocals() {
        return this.locals.length;
    }

    public void merge(LocalVariables localVariable) {
        if (this.locals.length != localVariable.locals.length) {
            throw new AssertionViolatedException("Merging LocalVariables of different size?!? From different methods or what?!?");
        }
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            this.merge(localVariable, i2);
        }
    }

    private void merge(LocalVariables lv, int i2) {
        try {
            if (!(this.locals[i2] instanceof UninitializedObjectType) && lv.locals[i2] instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
            }
            if (!this.locals[i2].equals(lv.locals[i2]) && this.locals[i2] instanceof UninitializedObjectType && lv.locals[i2] instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
            }
            if (this.locals[i2] instanceof UninitializedObjectType && !(lv.locals[i2] instanceof UninitializedObjectType)) {
                this.locals[i2] = ((UninitializedObjectType)this.locals[i2]).getInitialized();
            }
            if (this.locals[i2] instanceof ReferenceType && lv.locals[i2] instanceof ReferenceType) {
                if (!this.locals[i2].equals(lv.locals[i2])) {
                    ReferenceType sup = ((ReferenceType)this.locals[i2]).getFirstCommonSuperclass((ReferenceType)lv.locals[i2]);
                    if (sup == null) {
                        throw new AssertionViolatedException("Could not load all the super classes of '" + this.locals[i2] + "' and '" + lv.locals[i2] + "'.");
                    }
                    this.locals[i2] = sup;
                }
            } else if (!this.locals[i2].equals(lv.locals[i2])) {
                this.locals[i2] = Type.UNKNOWN;
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    public void set(int slotIndex, Type type) {
        if (type == Type.BYTE || type == Type.SHORT || type == Type.BOOLEAN || type == Type.CHAR) {
            throw new AssertionViolatedException("LocalVariables do not know about '" + type + "'. Use Type.INT instead.");
        }
        this.locals[slotIndex] = type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            sb.append(Integer.toString(i2));
            sb.append(": ");
            sb.append(this.locals[i2]);
            sb.append("\n");
        }
        return sb.toString();
    }
}

