/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer.sink;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.module.xhtml5.Xhtml5Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.siterenderer.DocumentContent;
import org.apache.maven.doxia.siterenderer.DocumentRenderingContext;
import org.codehaus.plexus.util.StringUtils;

public class SiteRendererSink
extends Xhtml5Sink
implements DocumentContent {
    private String date;
    private String title;
    private List<String> authors = new ArrayList<String>();
    private final StringWriter headWriter;
    private final Writer writer;
    private DocumentRenderingContext docRenderingContext;

    public SiteRendererSink(DocumentRenderingContext docRenderingContext) {
        this(new StringWriter(), docRenderingContext);
    }

    private SiteRendererSink(StringWriter writer, DocumentRenderingContext docRenderingContext) {
        super(writer);
        this.writer = writer;
        this.headWriter = new StringWriter();
        this.docRenderingContext = docRenderingContext;
        this.contentStack.push(HtmlMarkup.MAIN);
    }

    @Override
    public void title_() {
        if (this.getTextBuffer().length() > 0) {
            this.title = this.getTextBuffer().toString();
        }
        this.resetTextBuffer();
    }

    @Override
    public void title(SinkEventAttributes attributes) {
        this.resetTextBuffer();
    }

    @Override
    public void author(SinkEventAttributes attributes) {
        this.resetTextBuffer();
    }

    @Override
    public void author_() {
        if (this.getTextBuffer().length() > 0) {
            String text = this.getTextBuffer().toString().trim();
            this.authors.add(text);
        }
        this.resetTextBuffer();
    }

    @Override
    public void date(SinkEventAttributes attributes) {
        this.resetTextBuffer();
    }

    @Override
    public void date_() {
        if (this.getTextBuffer().length() > 0) {
            this.date = this.getTextBuffer().toString().trim();
        }
        this.resetTextBuffer();
    }

    @Override
    public void body_() {
    }

    @Override
    public void body(SinkEventAttributes attributes) {
    }

    @Override
    public void head_() {
        this.setHeadFlag(false);
    }

    @Override
    public void head(SinkEventAttributes attributes) {
        this.setHeadFlag(true);
    }

    @Override
    protected void write(String text) {
        String txt = text;
        if (this.isHeadFlag()) {
            this.headWriter.write(SiteRendererSink.unifyEOLs(txt));
            return;
        }
        if (this.docRenderingContext != null) {
            String relativePathToBasedir = this.docRenderingContext.getRelativePath();
            txt = relativePathToBasedir == null ? StringUtils.replace(txt, "$relativePath", ".") : StringUtils.replace(txt, "$relativePath", relativePathToBasedir);
        }
        super.write(txt);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<String> getAuthors() {
        return this.authors;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public String getBody() {
        String body = this.writer.toString();
        return body.length() > 0 ? body : null;
    }

    @Override
    public String getHead() {
        String head = this.headWriter.toString();
        return head.length() > 0 ? head : null;
    }

    @Override
    public DocumentRenderingContext getRenderingContext() {
        return this.docRenderingContext;
    }
}

