/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.DiscoverySelectorIdentifierParser;
import org.junit.platform.engine.discovery.DiscoverySelectors;

@API(status=API.Status.STABLE, since="1.0")
public class UniqueIdSelector
implements DiscoverySelector {
    private final UniqueId uniqueId;

    UniqueIdSelector(UniqueId uniqueId) {
        this.uniqueId = uniqueId;
    }

    public UniqueId getUniqueId() {
        return this.uniqueId;
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniqueIdSelector that = (UniqueIdSelector)o;
        return Objects.equals(this.uniqueId, that.uniqueId);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("uniqueId", this.uniqueId).toString();
    }

    @Override
    public Optional<DiscoverySelectorIdentifier> toIdentifier() {
        return Optional.of(DiscoverySelectorIdentifier.create("uid", this.uniqueId.toString()));
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static class IdentifierParser
    implements DiscoverySelectorIdentifierParser {
        private static final String PREFIX = "uid";

        @Override
        public String getPrefix() {
            return PREFIX;
        }

        public Optional<UniqueIdSelector> parse(DiscoverySelectorIdentifier identifier, DiscoverySelectorIdentifierParser.Context context) {
            return Optional.of(DiscoverySelectors.selectUniqueId(identifier.getValue()));
        }
    }
}

