/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.UsagePeriodType;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class UsagePeriod
extends AbstractBlock
implements Serializable,
Comparable<UsagePeriod> {
    public static final long serialVersionUID = 100000000017L;
    public static final int TAG_NOT_BEFORE = 0;
    public static final int TAG_NOT_AFTER = 1;
    protected long notBefore = -1L;
    protected long notAfter = -1L;
    protected Date reference = new Date();
    protected UsagePeriodType type;

    public UsagePeriod(long seconds) {
        this(0L, seconds);
    }

    public UsagePeriod(long startSeconds, long durationSeconds) {
        this(startSeconds, durationSeconds, new Date());
    }

    public UsagePeriod(long startSeconds, long durationSeconds, Date reference) {
        this.notBefore = reference.getTime() + startSeconds * 1000L;
        this.notAfter = this.notBefore + durationSeconds * 1000L;
        this.reference = new Date(reference.getTime());
        this.type = UsagePeriodType.RELATIVE;
    }

    public UsagePeriod() {
        this(Long.MAX_VALUE);
    }

    public UsagePeriod(UsagePeriod p) {
        this.notAfter = p.notAfter;
        this.notBefore = p.notBefore;
        this.reference = p.reference;
        this.type = p.type;
    }

    public UsagePeriod(Date from, Date to) {
        this.notBefore = from.getTime();
        this.notAfter = to.getTime();
        this.type = UsagePeriodType.ABSOLUTE;
    }

    public UsagePeriod(byte[] b) throws IOException {
        try (ASN1InputStream aIn = new ASN1InputStream(b);){
            this.parse((ASN1Encodable)aIn.readObject());
        }
    }

    public UsagePeriod(ASN1Encodable to) throws IOException {
        this.parse(to);
    }

    @Override
    protected final void parse(ASN1Encodable to) throws IOException {
        block11: {
            ASN1Sequence s2;
            ASN1TaggedObject s1;
            block10: {
                s1 = ASN1TaggedObject.getInstance((Object)to);
                s2 = ASN1Sequence.getInstance((Object)s1.getBaseObject());
                if (s1.getTagNo() != UsagePeriodType.ABSOLUTE.getId()) break block10;
                this.type = UsagePeriodType.ABSOLUTE;
                for (ASN1Encodable e : s2.toArray()) {
                    ASN1TaggedObject tag = ASN1TaggedObject.getInstance((Object)e);
                    if (tag.getTagNo() == 0 && this.notBefore == -1L) {
                        try {
                            this.notBefore = ASN1GeneralizedTime.getInstance((Object)tag.getBaseObject()).getDate().getTime();
                            continue;
                        }
                        catch (ParseException pe) {
                            throw new IOException("unable to parse notAfter", pe);
                        }
                    }
                    if (tag.getTagNo() == 1 && this.notAfter == -1L) {
                        try {
                            this.notAfter = ASN1GeneralizedTime.getInstance((Object)tag.getBaseObject()).getDate().getTime();
                            continue;
                        }
                        catch (ParseException pe) {
                            throw new IOException("unable to parse notAfter", pe);
                        }
                    }
                    throw new IOException("Encountered unknown or repeated Tag number in Usage Period (" + tag.getTagNo() + ")");
                }
                break block11;
            }
            if (s1.getTagNo() != UsagePeriodType.RELATIVE.getId()) break block11;
            this.type = UsagePeriodType.RELATIVE;
            this.reference = new Date();
            for (ASN1Encodable e : s2.toArray()) {
                ASN1TaggedObject tag = ASN1TaggedObject.getInstance((Object)e);
                if (tag.getTagNo() == 0 && this.notBefore == -1L) {
                    this.notBefore = ASN1Integer.getInstance((Object)tag.getBaseObject()).getValue().longValue() * 1000L + this.reference.getTime();
                    continue;
                }
                if (tag.getTagNo() == 1 && this.notAfter == -1L) {
                    this.notAfter = ASN1Integer.getInstance((Object)tag.getBaseObject()).getValue().longValue() * 1000L + this.reference.getTime();
                    continue;
                }
                throw new IOException("Encountered unknown or repeated Tag number in Usage Period (" + tag.getTagNo() + ")");
            }
        }
    }

    public Date getNotBefore() {
        return new Date(this.notBefore / 1000L);
    }

    public Date setNotBefore(Date validityStart) {
        Date d2 = new Date(this.notBefore / 1000L);
        this.notBefore = validityStart.getTime();
        this.type = UsagePeriodType.ABSOLUTE;
        return d2;
    }

    public Date getNotAfter() {
        return new Date(this.notAfter / 1000L);
    }

    public Date setNotAfter(Date pointInTime) {
        Date d2 = new Date(this.notAfter / 1000L);
        this.notAfter = pointInTime.getTime();
        this.type = UsagePeriodType.ABSOLUTE;
        return d2;
    }

    public long getBeforeInt() {
        return this.reference == null ? this.notBefore / 1000L : (this.notBefore - this.reference.getTime()) / 1000L;
    }

    public long getAfterInt() {
        return this.reference == null ? this.notAfter / 1000L : (this.notAfter - this.reference.getTime()) / 1000L;
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.type == UsagePeriodType.ABSOLUTE) {
            if (this.notBefore != -1L) {
                v.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERGeneralizedTime(new Date(this.notBefore))));
            }
            if (this.notAfter != -1L) {
                v.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new DERGeneralizedTime(new Date(this.notAfter))));
            }
        } else {
            if (this.notBefore != -1L) {
                v.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new ASN1Integer((this.notBefore - this.reference.getTime()) / 1000L)));
            }
            if (this.notAfter != -1L) {
                v.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new ASN1Integer((this.notAfter - this.reference.getTime()) / 1000L)));
            }
        }
        return new DERTaggedObject(this.type.getId(), (ASN1Encodable)new DERSequence(v));
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\r\n");
        if (this.type == UsagePeriodType.ABSOLUTE) {
            sb.append(prefix).append("  absolute [");
        } else if (this.type == UsagePeriodType.RELATIVE) {
            sb.append(prefix).append("  relative [");
        } else {
            sb.append(prefix).append("  /* UNKNOWN: ").append((Object)this.type).append(" */").append("\r\n");
        }
        sb.append(this.type.getId()).append("] {").append("\r\n");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddkkmmss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (this.notBefore != -1L) {
            sb.append(prefix).append("    notBefore ");
            if (this.type == UsagePeriodType.ABSOLUTE) {
                sb.append('\"').append(sdf.format(this.notBefore)).append("Z\"");
            } else {
                sb.append((this.notBefore - this.reference.getTime()) / 1000L);
            }
            sb.append(this.notAfter != -1L ? Character.valueOf(',') : "").append("\r\n");
        }
        if (this.notAfter != -1L) {
            sb.append(prefix).append("    notAfter  ");
            if (this.type == UsagePeriodType.ABSOLUTE) {
                sb.append('\"').append(sdf.format(this.notAfter)).append("Z\"");
            } else {
                sb.append((this.notAfter - this.reference.getTime()) / 1000L);
            }
            sb.append("\r\n");
        }
        sb.append(prefix).append("  ").append('}').append("\r\n");
        sb.append(prefix).append('}');
        return sb.toString();
    }

    public boolean inUsagePeriod() {
        return this.inUsagePeriod(this.reference);
    }

    public boolean inUsagePeriod(Date reference) {
        long now = new Date().getTime();
        return now >= this.notBefore && now <= this.notAfter;
    }

    @Override
    public int compareTo(UsagePeriod other) {
        if (this.getBeforeInt() > other.getBeforeInt()) {
            return 1;
        }
        if (this.getBeforeInt() == other.getBeforeInt()) {
            if (this.getAfterInt() == other.getAfterInt()) {
                if (this.type == UsagePeriodType.ABSOLUTE && other.type != UsagePeriodType.ABSOLUTE) {
                    return 1;
                }
                if (this.type == UsagePeriodType.RELATIVE && other.type != UsagePeriodType.RELATIVE) {
                    return -1;
                }
                return 0;
            }
            if (this.getAfterInt() > other.getAfterInt()) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o instanceof UsagePeriod) {
            return this.compareTo((UsagePeriod)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.dumpValueNotation("", DumpType.ALL).hashCode();
    }
}

