/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.commandline;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AlgorithmParameter;
import net.messagevortex.asn1.AsymmetricKey;
import net.messagevortex.asn1.SymmetricKey;
import net.messagevortex.asn1.encryption.Algorithm;
import net.messagevortex.asn1.encryption.AlgorithmType;
import net.messagevortex.asn1.encryption.DumpType;
import net.messagevortex.asn1.encryption.Mode;
import net.messagevortex.asn1.encryption.Padding;
import net.messagevortex.asn1.encryption.Parameter;
import picocli.CommandLine;

@CommandLine.Command(description={"symmetrically encrypt a file"}, name="encrypt", aliases={"enc"}, mixinStandardHelpOptions=true)
public class CommandLineHandlerCipherEncrypt
implements Callable<Integer> {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    @CommandLine.Option(names={"--infile", "-i"}, required=true, description={"filename of the file to handle"})
    String inFile;
    @CommandLine.Option(names={"--outfile", "-o"}, required=true, description={"output filename"})
    String outFile;
    @CommandLine.Option(names={"--keyfile", "-k"}, description={"keyfile"})
    String keyfile;
    @CommandLine.Option(names={"--ciphertype", "-c"}, description={"the cipher type"})
    String cipherType;
    @CommandLine.Option(names={"--ciphermode", "-m"}, description={"the cipher mode"})
    Mode cipherMode;
    @CommandLine.Option(names={"--cipherpadding", "-p"}, description={"the padding"})
    Padding cipherPadding;
    @CommandLine.Option(names={"--keysize", "-s"}, description={"the key size"})
    int keySize;
    @CommandLine.Option(names={"--outkey"}, description={"output filename for the generated or loaded key"})
    String outKey;

    @Override
    public Integer call() throws Exception {
        Algorithm ct;
        byte[] inBuffer = Files.readAllBytes(Paths.get(this.inFile, new String[0]));
        byte[] key = null;
        if (this.keyfile != null) {
            key = Files.readAllBytes(Paths.get(this.inFile, new String[0]));
        }
        if ((ct = Algorithm.getByString(this.cipherType)) == null) {
            throw new IOException("Unknown cipher type");
        }
        if (ct.getAlgorithmType() == AlgorithmType.ASYMMETRIC) {
            AsymmetricKey k;
            if (key != null) {
                k = new AsymmetricKey(key);
            } else {
                AlgorithmParameter algParam = new AlgorithmParameter();
                algParam.put(Parameter.KEYSIZE, "" + this.keySize);
                algParam.put(Parameter.ALGORITHM, ct.toString());
                algParam.put(Parameter.MODE, this.cipherMode.toString());
                algParam.put(Parameter.PADDING, this.cipherPadding.toString());
                k = new AsymmetricKey(algParam);
            }
            try (OutputStream fos = Files.newOutputStream(Paths.get(this.outFile, new String[0]), new OpenOption[0]);){
                fos.write(k.encrypt(inBuffer));
            }
            if (this.outKey != null) {
                try (OutputStream fosk = Files.newOutputStream(Paths.get(this.outKey, new String[0]), new OpenOption[0]);){
                    fosk.write(k.toBytes(DumpType.ALL_UNENCRYPTED));
                }
            }
        } else if (ct.getAlgorithmType() == AlgorithmType.SYMMETRIC) {
            SymmetricKey k = key != null ? new SymmetricKey(key) : new SymmetricKey(ct, this.cipherPadding, this.cipherMode);
            System.out.println("writing encrypted file " + this.outFile);
            try (OutputStream fos = Files.newOutputStream(Paths.get(this.outFile, new String[0]), new OpenOption[0]);){
                fos.write(k.encrypt(inBuffer));
            }
            if (this.outKey != null) {
                System.out.println("writing key file " + this.outKey);
                try (OutputStream fosk = Files.newOutputStream(Paths.get(this.outKey, new String[0]), new OpenOption[0]);){
                    fosk.write(k.toBytes(DumpType.ALL_UNENCRYPTED));
                }
            }
        } else {
            throw new IOException("Unhandleable cipher type");
        }
        return 0;
    }
}

