/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.dependencies;

import java.util.List;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class SinkSerializingDependencyNodeVisitor
implements DependencyNodeVisitor {
    private final Sink sink;
    private final TreeTokens tokens;
    private int depth;

    public SinkSerializingDependencyNodeVisitor(Sink sink) {
        this.sink = sink;
        this.tokens = new TreeTokens(sink);
        this.depth = 0;
    }

    public boolean visit(DependencyNode node) {
        this.indent(node);
        this.sink.text(node.toNodeString());
        this.sink.lineBreak();
        ++this.depth;
        return true;
    }

    public boolean endVisit(DependencyNode node) {
        --this.depth;
        return true;
    }

    private void indent(DependencyNode node) {
        for (int i = 1; i < this.depth; ++i) {
            this.tokens.fillIndent(this.isLast(node, i));
        }
        if (this.depth > 0) {
            this.tokens.addNodeIndent(this.isLast(node));
        }
    }

    private boolean isLast(DependencyNode node) {
        List siblings;
        DependencyNode parent = node.getParent();
        boolean last = parent == null ? true : (siblings = parent.getChildren()).indexOf(node) == siblings.size() - 1;
        return last;
    }

    private boolean isLast(DependencyNode node, int ancestorDepth) {
        int distance = this.depth - ancestorDepth;
        while (distance-- > 0) {
            node = node.getParent();
        }
        return this.isLast(node);
    }

    private class TreeTokens {
        private final Sink sink;

        TreeTokens(Sink sink) {
            this.sink = sink;
        }

        void addNodeIndent(boolean last) {
            if (last) {
                this.sink.text("\\-");
                this.sink.nonBreakingSpace();
            } else {
                this.sink.text("+-");
                this.sink.nonBreakingSpace();
            }
        }

        void fillIndent(boolean last) {
            if (last) {
                this.sink.nonBreakingSpace();
                this.sink.nonBreakingSpace();
                this.sink.nonBreakingSpace();
            } else {
                this.sink.text("|");
                this.sink.nonBreakingSpace();
                this.sink.nonBreakingSpace();
            }
        }
    }
}

