/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.EmptyStatement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class InstanceTrackingConfig {
    public static final Path DEFAULT_FILE = Paths.get(System.getProperty("java.io.tmpdir"), "Hazelcast.process");
    public static final String PLACEHOLDER_NAMESPACE = "HZ_INSTANCE_TRACKING";
    boolean isEnabledSet;
    private boolean enabled = InstanceTrackingConfig.isOEMBuild();
    private String fileName;
    private String formatPattern;

    public InstanceTrackingConfig() {
    }

    public InstanceTrackingConfig(InstanceTrackingConfig other) {
        this.enabled = other.enabled;
        this.fileName = other.fileName;
        this.formatPattern = other.formatPattern;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public InstanceTrackingConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.isEnabledSet = true;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public InstanceTrackingConfig setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public InstanceTrackingConfig setFormatPattern(String formatPattern) {
        this.formatPattern = formatPattern;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceTrackingConfig that = (InstanceTrackingConfig)o;
        return this.enabled == that.enabled && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.formatPattern, that.formatPattern);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.fileName, this.formatPattern);
    }

    public String toString() {
        return "InstanceTrackingConfig{enabled=" + this.enabled + ", fileName='" + this.fileName + "', formatPattern='" + this.formatPattern + "'}";
    }

    private static boolean isOEMBuild() {
        try {
            Class<?> helper = Class.forName("com.hazelcast.instance.impl.BuiltInLicenseHolder");
            Method getLicense = helper.getMethod("getBuiltInLicense", new Class[0]);
            return getLicense.invoke(null, new Object[0]) != null;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            EmptyStatement.ignore(e);
            return false;
        }
    }

    public static enum InstanceMode {
        SERVER("server"),
        CLIENT("client"),
        EMBEDDED("embedded");

        private final String modeName;

        private InstanceMode(String modeName) {
            this.modeName = modeName;
        }

        public String getModeName() {
            return this.modeName;
        }
    }

    public static enum InstanceProductName {
        HAZELCAST("Hazelcast"),
        HAZELCAST_EE("Hazelcast Enterprise"),
        HAZELCAST_CLIENT("Hazelcast Client"),
        HAZELCAST_CLIENT_EE("Hazelcast Client Enterprise"),
        HAZELCAST_JET("Hazelcast Jet"),
        HAZELCAST_JET_EE("Hazelcast Jet Enterprise");

        private final String productName;

        private InstanceProductName(String productName) {
            this.productName = productName;
        }

        public String getProductName() {
            return this.productName;
        }
    }

    public static enum InstanceTrackingProperties {
        PRODUCT("product"),
        VERSION("version"),
        MODE("mode"),
        START_TIMESTAMP("start_timestamp"),
        LICENSED("licensed"),
        PID("pid");

        private final String propertyName;

        private InstanceTrackingProperties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

