/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.internal.util.Preconditions;
import java.util.Objects;

public class SqlConfig {
    public static final int DEFAULT_STATEMENT_TIMEOUT_MILLIS = 0;
    private long statementTimeoutMillis = 0L;
    private boolean catalogPersistenceEnabled;
    private JavaSerializationFilterConfig javaReflectionFilterConfig;

    public long getStatementTimeoutMillis() {
        return this.statementTimeoutMillis;
    }

    public SqlConfig setStatementTimeoutMillis(long statementTimeoutMillis) {
        Preconditions.checkNotNegative(statementTimeoutMillis, "Timeout cannot be negative");
        this.statementTimeoutMillis = statementTimeoutMillis;
        return this;
    }

    public boolean isCatalogPersistenceEnabled() {
        return this.catalogPersistenceEnabled;
    }

    public SqlConfig setCatalogPersistenceEnabled(boolean catalogPersistenceEnabled) {
        this.catalogPersistenceEnabled = catalogPersistenceEnabled;
        return this;
    }

    public JavaSerializationFilterConfig getJavaReflectionFilterConfig() {
        return this.javaReflectionFilterConfig;
    }

    public void setJavaReflectionFilterConfig(JavaSerializationFilterConfig javaReflectionFilterConfig) {
        this.javaReflectionFilterConfig = javaReflectionFilterConfig;
    }

    public String toString() {
        return "SqlConfig{statementTimeoutMillis=" + this.statementTimeoutMillis + ", catalogPersistenceEnabled=" + this.catalogPersistenceEnabled + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlConfig sqlConfig = (SqlConfig)o;
        return this.statementTimeoutMillis == sqlConfig.statementTimeoutMillis && this.catalogPersistenceEnabled == sqlConfig.catalogPersistenceEnabled && Objects.equals(this.javaReflectionFilterConfig, sqlConfig.javaReflectionFilterConfig);
    }

    public int hashCode() {
        return Objects.hash(this.statementTimeoutMillis, this.catalogPersistenceEnabled, this.javaReflectionFilterConfig);
    }
}

